/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.gui.widgets;

import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.booleans.Boolean2ObjectFunction;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jspecify.annotations.Nullable;

public class DynamicImageButton
extends Button {
    private final Boolean2ObjectFunction<ResourceLocation> texture;
    private final Supplier<HintedMessage> message;

    public DynamicImageButton(int x, int y, int width, int height, Boolean2ObjectFunction<ResourceLocation> texture, Button.OnPress onPress, HintedMessage message) {
        this(x, y, width, height, texture, onPress, () -> message);
    }

    public DynamicImageButton(int x, int y, int width, int height, Boolean2ObjectFunction<ResourceLocation> texture, Button.OnPress onPress, Supplier<HintedMessage> message) {
        super(x, y, width, height, (Component)Component.empty(), onPress, DEFAULT_NARRATION);
        this.texture = texture;
        this.message = message;
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        HintedMessage message = this.message.get();
        this.setMessage(message.message());
        this.setTooltip(message.tooltip());
        ResourceLocation texture = (ResourceLocation)this.texture.get(this.isHoveredOrFocused());
        RenderSystem.disableDepthTest();
        graphics.blitSprite(texture, this.getX(), this.getY(), 0, this.width, this.height);
        RenderSystem.enableDepthTest();
    }

    public record HintedMessage(Component message, Tooltip tooltip) {
        public HintedMessage(Component message, @Nullable Component hint) {
            this(message, hint == null ? Tooltip.create((Component)message) : Tooltip.create((Component)Component.empty().append(message).append("\n").append((Component)hint.copy().withStyle(ChatFormatting.GRAY)), (Component)hint));
        }
    }
}

